package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemUserMessageBinding
import ai.engagely.openbot.model.pojos.internal.chat.IMessageItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.LinearLayout

class ItemUserMessageView : FrameLayout {

    private var binding: ViewItemUserMessageBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemUserMessageBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        messageItem: IMessageItem?,
        bgColor: Int,
        textColor: Int,
        onItemClickListener: OnClickListener
    ) {
        binding?.tvMessage?.text = messageItem?.message
        binding?.tvMessage?.setTextColor(textColor)
        binding?.rlMessageContainer?.setCardBackgroundColor(bgColor)
        binding?.tvTime?.setData(messageItem?.date)

        var timeTopSpacing = 0
        messageItem?.pendingData?.let {
            binding?.vFailureStatus?.visibility = VISIBLE
            binding?.vFailureStatus?.tag = messageItem
            binding?.vFailureStatus?.setOnClickListener(onItemClickListener)
        } ?: run {
            binding?.vFailureStatus?.visibility = GONE
            timeTopSpacing =
                resources.getDimension(R.dimen.message_bubble_time_vertical_spacing).toInt()
        }

        if (binding?.tvTime?.layoutParams is LinearLayout.LayoutParams) {
            val timeLayoutParams = binding?.tvTime?.layoutParams as LinearLayout.LayoutParams
            timeLayoutParams.setMargins(
                timeLayoutParams.leftMargin,
                timeTopSpacing,
                timeLayoutParams.rightMargin,
                timeLayoutParams.bottomMargin
            )
        }
    }
}