package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewNetworkStatusStripBinding
import ai.engagely.openbot.viewmodel.NetworkStateAwareViewModel
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.content.ContextCompat
import java.util.concurrent.TimeUnit

class NetworkStatusStripView : FrameLayout {

    private var binding: ViewNetworkStatusStripBinding? = null
    private var hideViewRunnable: Runnable? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewNetworkStatusStripBinding.inflate(LayoutInflater.from(context), this, true)
        visibility = GONE
    }

    private fun setData(message: String?, isConnected: Boolean?) {
        if (hideViewRunnable != null) {
            removeCallbacks(hideViewRunnable)
        }
        when (isConnected) {
            true -> {
                setBackgroundColor(ContextCompat.getColor(context, R.color.network_available_green))
                hideViewRunnable = Runnable {
                    try {
                        visibility = GONE
                    } catch (e: Exception) {
                    }
                }
                postDelayed(hideViewRunnable, TimeUnit.SECONDS.toMillis(3))
            }
            false -> {
                visibility = VISIBLE
                setBackgroundColor(ContextCompat.getColor(context, R.color.no_network_red))
            }
            else -> {
                visibility = GONE
            }
        }

        binding?.tvStatus?.text = message
    }

    fun setData(networkState: NetworkStateAwareViewModel.NetworkState?) {
        val message = when (networkState) {
            NetworkStateAwareViewModel.NetworkState.CONNECTED -> resources.getString(R.string.online)
            NetworkStateAwareViewModel.NetworkState.DISCONNECTED -> resources.getString(R.string.offline)
            else -> null
        }
        val isConnected = when (networkState) {
            NetworkStateAwareViewModel.NetworkState.CONNECTED -> true
            NetworkStateAwareViewModel.NetworkState.DISCONNECTED -> false
            else -> null
        }
        setData(message, isConnected)
    }
}