package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewQuickMenuItemBinding
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class QuickMenuItemView : FrameLayout {

    private var binding: ViewQuickMenuItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewQuickMenuItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(imageUrl: String?, name: String?) {
        imageUrl?.let { url ->
            binding?.ivMenuImage?.let { imageView ->
                ImageUtils.loadImage(context, url, imageView)
            }
        }
        binding?.tvMenuName?.text = name
    }
}