package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewShowPhotoOverlayBinding
import ai.engagely.openbot.model.pojos.internal.common.IViewImageData
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.graphics.Bitmap
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ShowPhotoOverlayView : FrameLayout {

    private var binding: ViewShowPhotoOverlayBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewShowPhotoOverlayBinding.inflate(LayoutInflater.from(context), this, true)

        binding?.ibClose?.setOnClickListener {
            visibility = GONE
        }
    }

    fun setData(imageData: IViewImageData?) {
        binding?.ivPhoto?.let { imageView ->
            (imageData?.imageSource as? String)?.let { url ->
                ImageUtils.loadImage(context, url, imageView)
            }

            (imageData?.imageSource as? Bitmap)?.let { bitmap ->
                ImageUtils.loadImage(context, bitmap, imageView)
            }
        }
        visibility = VISIBLE
    }
}