package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewTabularInfoBinding
import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater

class TabularInfoView : TabularInfoBaseView {

    private var binding: ViewTabularInfoBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewTabularInfoBinding.inflate(LayoutInflater.from(context), this, true)
        binding?.mapViewLight?.visibility = GONE
    }

    fun setData(
        tabularInfoItem: ITabularInfoItem?,
        bgColor: Int,
        onClickListener: OnClickListener
    ) {
        setData(
            binding?.llTabularItems,
            binding?.tvTime,
            binding?.rlMessageContainer,
            binding?.actionButton,
            tabularInfoItem,
            bgColor,
            onClickListener
        )
    }
}