package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewUploadPhotoOverlayBinding
import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatPhotoData
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.content.ContextCompat

class UploadPhotoOverlayView : FrameLayout {

    private var binding: ViewUploadPhotoOverlayBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewUploadPhotoOverlayBinding.inflate(LayoutInflater.from(context), this, true)

        binding?.ibClose?.setOnClickListener {
            this.visibility = GONE
        }

        binding?.messageUnderline?.setColor(ContextCompat.getColor(context, R.color.white))
    }

    fun setData(data: ILiveChatPhotoData?, onClickListener: OnClickListener) {
        data?.uploadedUrl?.let { uploadedUrl ->
            binding?.ivPhotoToBeSent?.let { ivPhotoToBeSent ->
                ImageUtils.loadImage(context, uploadedUrl, ivPhotoToBeSent)
            }
        }
        binding?.ibSend?.tag = data
        binding?.ibSend?.setOnClickListener(onClickListener)
        setIsLoading(true == data?.isUploading)

        binding?.ibSend?.visibility = if (true == data?.isSendingMessage) GONE else VISIBLE
        binding?.pbSending?.visibility = if (true == data?.isSendingMessage) VISIBLE else GONE

        if (true == data?.clearMessage) {
            binding?.etMessage?.setText("")
        }

        this.visibility = if (true == data?.showPhotoView) VISIBLE else GONE
    }

    private fun setIsLoading(loading: Boolean) {
        binding?.pbLoading?.visibility = if (loading) VISIBLE else GONE
        binding?.ivPhotoToBeSent?.visibility = if (loading) GONE else VISIBLE
        binding?.etMessage?.visibility = if (loading) GONE else VISIBLE
        binding?.ibSendContainer?.visibility = if (loading) GONE else VISIBLE
        binding?.messageUnderline?.visibility = if (loading) GONE else VISIBLE
    }

    fun getMessage(): String? {
        return binding?.etMessage?.text?.toString()?.ifBlank { null }
    }
}