package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewVerticalSpaceBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class VerticalSpaceView : FrameLayout {

    private var binding: ViewVerticalSpaceBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewVerticalSpaceBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(height: Int?) {
        val finalHeight =
            height ?: resources.getDimension(R.dimen.common_vertical_space_small).toInt()
        binding?.vVerticalSpace?.layoutParams?.apply {
            this.height = finalHeight
        }?.also {
            binding?.vVerticalSpace?.layoutParams = it
        }
    }
}