package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewWelcomeVideoBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.ImageButton
import com.google.android.exoplayer2.ui.PlayerView

class WelcomeVideoView : FrameLayout {

    private var binding: ViewWelcomeVideoBinding? = null
    private var onPlayClickListener: OnPlayClickListener? = null
    private var ibFullScreen: ImageButton? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewWelcomeVideoBinding.inflate(LayoutInflater.from(context), this, true)
        ibFullScreen = binding?.playerView?.findViewById<ImageButton>(R.id.ib_full_screen)
    }

    fun setData(url: String, onPlayClickListener: OnPlayClickListener?) {
        this.onPlayClickListener = onPlayClickListener
        binding?.btPlay?.tag = url
        binding?.btPlay?.setOnClickListener {
            if (it.tag is String) {
                val urlTag = it.tag as String
                setPlaying(true)
                this.onPlayClickListener?.onPlayClicked(binding?.playerView, urlTag)
            }
        }
        ibFullScreen?.setOnClickListener {
            this.onPlayClickListener?.onFullScreenClicked(binding?.playerView)
        }

        setPlaying(false)
    }

    private fun setPlaying(isPlaying: Boolean) {
        if (isPlaying) {
            binding?.playerViewOverlay?.visibility = GONE
            binding?.btPlay?.visibility = GONE
        } else {
            binding?.playerViewOverlay?.visibility = VISIBLE
            binding?.btPlay?.visibility = VISIBLE
        }
    }

    interface OnPlayClickListener {
        fun onPlayClicked(playerView: PlayerView?, url: String?)
        fun onFullScreenClicked(playerView: PlayerView?)
    }
}