package ai.engagely.openbot.model.localstorage.impl

import ai.engagely.openbot.model.localstorage.SimpleKeyValueStorage
import android.content.Context
import androidx.datastore.core.DataStore
import androidx.datastore.preferences.core.Preferences
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringPreferencesKey
import androidx.datastore.preferences.preferencesDataStore
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.flow.map

private val Context.dataStore: DataStore<Preferences> by preferencesDataStore(name = "simple_key_value_storage")

class PreferenceDataStore(private val context: Context) : SimpleKeyValueStorage {

    override suspend fun storeStringDataForKey(key: String, data: String?) {
        val prefKey = stringPreferencesKey(key)
        context.dataStore.edit { preferences ->
            preferences[prefKey] = data ?: ""
        }
    }

    override suspend fun readStringDataForKey(key: String): String? {
        val prefKey = stringPreferencesKey(key)
        val valueFlow: Flow<String?> = context.dataStore.data
            .map { preferences ->
                // No type safety.
                preferences[prefKey]
            }
        return valueFlow.first()
    }
}