package ai.engagely.openbot.model.pojos.internal.botsettings

import android.graphics.Bitmap
import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class IBotChatWindowConfig(
    val toolbarTitle: String?,
    val logo: Bitmap?,
    val userChatBoxColor: String?,
    val userTextColor: String?,
    val headerTextColor: String?,
    val defaultILanguage: ILanguage?,
    val languageData: List<ILanguage>?,
    val topJrItems: List<ITopJr>?,
    val quickMenuItems: List<IQuickMenuItem>?,
    val quickMenuPosition: IQuickMenuPosition?,
    val botBgColor: String?,
    val botChatBoxColor: String?,
    val botButtonColor: String?,
    val botTextColor: String?,
    val botThemColor: String?,
    val buttonColor: String?,
    val linkColor: String?,
    val userInputBoxColor: String?,
    val botId: String?,
    val intId: String?,
    val intName: String?,
    val greetingMessage: IGreetingMessage?,
    val greetingMessageWithHeader: IGreetingMessageWithHeader?,
    val carousalGreetingMessage: ICarousalGreetingMessage?,
    val optionsStyle: IOptionsStyle?,
    val topJourneyHeader: String?,
    val enableGreetingJourney: Boolean,
    val greetingJourney: String?,
    val autoCompleteEnabled: Boolean,
    val showWelcomeMessage: Boolean,
    val botImageShape: BotImageShape,
    val botImageSize: BotImageSize,
    val enableMic: Boolean,
    val enableSpeech: Boolean,
    val iBotFeedbackRequest: IBotFeedbackRequest?
) : Parcelable {
    companion object {
        const val UNIQUE_NAME = "bot_chat_window_config"
    }

    enum class BotImageShape { TRIPPED, ROUNDED }

    enum class BotImageSize { STANDARD, SMALL }
}