package ai.engagely.openbot.view.activities

import ai.engagely.openbot.databinding.ActivityOpenBotChatBinding
import ai.engagely.openbot.model.utils.helpers.BotViewHelper
import android.content.res.Configuration
import android.os.Bundle
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout


abstract class OpenBotActivity : BaseActivity() {

    private lateinit var binding: ActivityOpenBotChatBinding
    private lateinit var botViewHelper: BotViewHelper

    protected fun initBot(botId: String, extras: Map<String, String>? = null) {
        botViewHelper = BotViewHelper(this, binding.botContainer)
        botViewHelper.init(botId, extras)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityOpenBotChatBinding.inflate(layoutInflater)
    }

    override fun setContentView(layoutResID: Int) {
        val view = layoutInflater.inflate(layoutResID, binding.openBotMainContainer, false)
        binding.openBotMainContainer.addView(view, 0)
        super.setContentView(binding.root)
    }

    override fun setContentView(view: View?) {
        binding.openBotMainContainer.addView(view, 0)
        super.setContentView(binding.root)
    }

    override fun setContentView(view: View?, params: ViewGroup.LayoutParams?) {
        binding.openBotMainContainer.addView(view, 0)
        params?.let {
            binding.openBotMainContainer.layoutParams = it
        }
        super.setContentView(binding.root)
    }

    fun setBotMargin(marginBottom: Float, marginEnd: Float) {
        val botLayoutParams = binding.botContainer.layoutParams as FrameLayout.LayoutParams
        if (marginEnd > 0) {
            botLayoutParams.marginEnd = marginEnd.toInt()
        }
        if (marginBottom > 0) {
            botLayoutParams.bottomMargin = marginBottom.toInt()
        }
        binding.botContainer.layoutParams = botLayoutParams
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        botViewHelper.onConfigurationChanged(newConfig)
    }
}