package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewCompanyAboutLinkBinding
import ai.engagely.openbot.model.network.ApiConstants
import ai.engagely.openbot.model.pojos.internal.common.IOpenUrlData
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class CompanyAboutLinkView : FrameLayout {

    private var binding: ViewCompanyAboutLinkBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewCompanyAboutLinkBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setColor(color: Int) {
        binding?.tvCompanyName?.setTextColor(color)
    }

    fun setData(onClickListener: OnClickListener) {
        binding?.tvCompanyName?.tag = IOpenUrlData(url = ApiConstants.COMPANY_URL)
        binding?.tvCompanyName?.setOnClickListener(onClickListener)
    }
}