package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemFileViewBinding
import ai.engagely.openbot.model.pojos.internal.chat.IFileItem
import ai.engagely.openbot.model.utils.exts.obtainNonBlankOrNull
import ai.engagely.openbot.model.utils.general.FileUtils
import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.util.TypedValue
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.RelativeLayout

class ItemFileView : FrameLayout {

    private var binding: ViewItemFileViewBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemFileViewBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFileItem: IFileItem?, themeColor: Int, itemClickListener: OnClickListener) {
        binding?.ivDownload?.imageTintList = ColorStateList.valueOf(themeColor)
        binding?.ivDownload?.tag = iFileItem
        binding?.ivDownload?.setOnClickListener(itemClickListener)

        binding?.tvFileName?.text = iFileItem?.fileName
        binding?.tvFileSize?.text =
            if (iFileItem?.fileSizeString?.isNotBlank() == true) iFileItem.fileSizeString
            else FileUtils.formatToFileSize(context, iFileItem?.fileSize ?: 0)

        binding?.tvTime?.setData(iFileItem?.date)

        if (iFileItem?.hideSideSpaces == true) {
            binding?.vLeftSpacing?.visibility = GONE
            binding?.vRightSpacing?.visibility = GONE
            binding?.tvTime?.visibility = GONE
            setMainContainerWeight(1f)
        } else {
            val isUserItem = iFileItem?.isBotItem == false
            binding?.vLeftSpacing?.visibility = if (isUserItem) VISIBLE else GONE
            binding?.vRightSpacing?.visibility = if (isUserItem) GONE else VISIBLE

            binding?.tvTime?.layoutParams = RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.WRAP_CONTENT,
                RelativeLayout.LayoutParams.WRAP_CONTENT
            ).apply {
                addRule(if (isUserItem) RelativeLayout.ALIGN_PARENT_END else RelativeLayout.ALIGN_PARENT_START)
            }

            setMainContainerWeight(TypedValue().also {
                resources.getValue(R.dimen.chat_bubble_width_fraction, it, true)
            }.float)
        }

        iFileItem?.fileText.obtainNonBlankOrNull()?.let { videoText ->
            binding?.tvFileText?.visibility = VISIBLE
            binding?.tvFileText?.text = videoText
        } ?: kotlin.run {
            binding?.tvFileText?.visibility = GONE
        }
    }

    private fun setMainContainerWeight(weight: Float) {
        (binding?.vMainContainer?.layoutParams as? LinearLayout.LayoutParams)?.let { layoutParams ->
            layoutParams.weight = weight
            binding?.vMainContainer?.layoutParams = layoutParams
        }
    }
}