package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewTabularValueItemBinding
import ai.engagely.openbot.model.utils.general.LogUtils
import android.content.Context
import android.graphics.Typeface
import android.text.Spannable
import android.text.SpannableString
import android.text.style.StyleSpan
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.text.parseAsHtml

class TabularValueItemView : FrameLayout {

    private var binding: ViewTabularValueItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewTabularValueItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(key: String, value: String, color: Int) {

        binding?.tvValue?.setTextColor(color)
        var parsedKey: CharSequence?
        var parsedValue: CharSequence?
        try {
            parsedKey = key.parseAsHtml().trimEnd()
            parsedValue = value.parseAsHtml().trimEnd()
        } catch (e: Exception) {
            LogUtils.logException(e)
            parsedKey = key
            parsedValue = value
        }
        val spannable = SpannableString("$parsedKey: $parsedValue")
        spannable.setSpan(
            StyleSpan(Typeface.BOLD),
            0,
            key.length + 1,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        binding?.tvValue?.text = spannable
    }
}