package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewWelcomeMessageBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class WelcomeMessageView : FrameLayout {

    private var binding: ViewWelcomeMessageBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewWelcomeMessageBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(message: String, color: Int) {
        binding?.tvMessage?.text = message
        binding?.tvMessage?.setTextColor(color)

        binding?.vTopStrip?.setBackgroundColor(color)
    }
}