package ai.engagely.openbot.model.pojos.internal.botsettings

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class IBotFeedbackRequest(
    val surveyMessage: String?,
    var selectedIndex: Int = 0,
    var isSubmitting: Boolean = false,
    var iBotFeedbackSubmitStatus: IBotFeedbackSubmitStatus = IBotFeedbackSubmitStatus.NOT_SUBMITTED,
    var iBotFeedbackClickedStatus: IBotFeedbackClickedStatus = IBotFeedbackClickedStatus.NOT_CLICKED,
    var showAfterSeconds: Int = 0,
    var showAfterMessages: Int = 0
) : Parcelable {
    enum class IBotFeedbackSubmitStatus { SUBMITTED_POSITIVE, SUBMITTED_NEGATIVE, NOT_SUBMITTED }
    enum class IBotFeedbackClickedStatus { CLICKED_POSITIVE, CLICKED_NEGATIVE, NOT_CLICKED }
}
