package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IChatConflictItem(
    val message: String,
    val faqList: List<IChatConflictChildItem>,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    isBotItem = isBotItem,
    date = date,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IChatConflictItem(
            message = message,
            faqList = faqList,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}