package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IMessagesItem(
    val messages: List<Any>,
    val isHtml: Boolean = false,
    val isVoiceMessage: Boolean = false,
    var isVoicePlaying: Boolean = false,
    var hideTime: Boolean = false,
    val messagesStyle: IMessagesStyle = IMessagesStyle.MESSAGES,
    val extras: Any? = null,
    date: Date? = null,
    isLoading: Boolean = false,
    isBotItem: Boolean = false,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {
    override fun makeACopy(): IChatItem {
        return IMessagesItem(
            messages = messages,
            isHtml = isHtml,
            isVoiceMessage = isVoiceMessage,
            isVoicePlaying = isVoicePlaying,
            hideTime = hideTime,
            messagesStyle = messagesStyle,
            extras = extras,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }

    enum class IMessagesStyle { MESSAGES, FORM }
}