package ai.engagely.openbot.model.pojos.internal.livechat

import ai.engagely.openbot.model.constants.ServerConstants
import ai.engagely.openbot.model.utils.general.LogUtils
import com.google.gson.internal.LinkedTreeMap

data class ILiveChatForm(
    val displayField: Any?,
    val displayOutput: String?,
    val field: Any?,
    val formData: Any?,
    val inputMethod: String?,
    val inputType: String?,
    val settingId: String?,
    val value: Any?,
    var userTeam: String?,
    var chatItemIdsToRemove: ArrayList<String>?
) {
    fun addChatItemsToRemove(uuid: String) {
        if (chatItemIdsToRemove == null) {
            chatItemIdsToRemove = ArrayList()
        }
        chatItemIdsToRemove?.add(uuid)
    }

    fun clearChatItemsToRemove() {
        chatItemIdsToRemove?.clear()
    }

    fun getDefaultFormUserName(): String? {
        try {
            if (inputType == ServerConstants.LIVE_CHAT_INPUT_TYPE_NO_FORM) {
                (displayField as? String)?.let { df ->
                    (value as? LinkedTreeMap<*, *>)?.let { v ->
                        v.forEach { item ->
                            if (item.key is String && item.value is String && item.key == df) {
                                return item.value as? String
                            }
                        }
                    }
                }
            }
        } catch (e: Exception) {
            LogUtils.logException(e)
        }
        return null
    }
}
