package ai.engagely.openbot.model.repositories

import ai.engagely.openbot.model.pojos.internal.chat.IChatItem
import ai.engagely.openbot.model.pojos.internal.livechat.*
import ai.engagely.openbot.model.pojos.internal.location.ILocation
import java.io.File

interface LiveChatRepository {

    suspend fun getLiveAgentConnectionDetails(intId: String?, sessionId: String?): ILiveChatForm?

    suspend fun sendAgentConnectRequest(
        botId: String?,
        channel: String,
        displayOutput: String?,
        fetchApi: Boolean,
        formData: Any?,
        prevLangCode: String?,
        sessionId: String?,
        settingId: String?,
        userId: String?,
        userIntId: String?,
        userIntName: String?,
        osName: String?,
        osVersion: String?,
        screenWidth: Int?,
        screenHeight: Int?,
        screenOrientation: String?,
        userName: String?,
        currentSessionId: String?,
        socketId: String?,
        userTeam: String?,
        teamList: List<ILiveChatTeam>?,
        location: ILocation?,
        userProperty: Any?
    ): Boolean

    suspend fun sendJoinMeHereRequest(liveChatData: ILiveChatData): Boolean

    suspend fun sendMessage(
        liveChatData: ILiveChatData?,
        channel: String?,
        intId: String?,
        intName: String?,
        prevLangCode: String?,
        queryType: String?,
        sessionId: String?,
        sessionObj: Any?,
        userId: String?,
        userInput: Any?,
        userLang: String?,
        userLangCode: String?,
        responseType: String?
    ): Boolean

    suspend fun endLiveChat(
        agentLangCode: String?,
        botId: String?,
        endedBy: String?,
        sessionId: String?,
        userId: String?,
        userLangCode: String?
    ): Boolean

    suspend fun terminateSession(
        sessionId: String?,
        intId: String?,
        userId: String?,
        endedBy: String?,
        prevLangCode: String?
    ): Boolean

    suspend fun handleMedia(botId: String, file: File, mimeType: String): ILiveChatMediaData?

    suspend fun saveLiveChatDetails(liveChatData: ILiveChatData?)

    suspend fun readLiveChatDetails(): ILiveChatData?

    suspend fun sendUserFeedback(
        liveChatData: ILiveChatData,
        selectedFeedbackIndex: Int
    ): Any?

    suspend fun sendUserAdditionalFeedback(
        liveChatData: ILiveChatData,
        additionalQuestion: ILiveChatFeedbackAdditionalQuestion?
    ): Any?

    suspend fun processBusinessAwayForm(iLiveChatBusinessAwayData: ILiveChatBusinessAwayData): List<IChatItem>?
}