package ai.engagely.openbot.model.utils.helpers

import ai.engagely.openbot.model.pojos.internal.chat.IChatItem
import ai.engagely.openbot.model.utils.general.LogUtils
import androidx.recyclerview.widget.DiffUtil

class ChatDiffUtilsHelper(
    private val oldItems: List<IChatItem>,
    private val newItems: List<IChatItem>
) : DiffUtil.Callback() {

    override fun getOldListSize(): Int {
        return oldItems.size
    }

    override fun getNewListSize(): Int {
        return newItems.size
    }

    override fun areItemsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
        return oldItems[oldItemPosition].uuid == newItems[newItemPosition].uuid
    }

    override fun areContentsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
        return compareItems(oldItemPosition, newItemPosition)
    }

    private fun compareItems(oldItemPosition: Int, newItemPosition: Int): Boolean {
        return try {
            val oldItem = oldItems[oldItemPosition]
            val newItem = newItems[newItemPosition]
            oldItem == newItem
        } catch (e: Exception) {
            LogUtils.logException(e)
            false
        }
    }
}