package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewFormRadioButtonsBinding
import ai.engagely.openbot.model.pojos.internal.history.IFormItem
import ai.engagely.openbot.model.pojos.internal.history.IFormItemCheckableOption
import ai.engagely.openbot.model.pojos.internal.history.IFormRadioButtonsItem
import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.RadioButton
import androidx.core.view.children

class FormRadioButtonsView : FrameLayout {

    private var binding: ViewFormRadioButtonsBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewFormRadioButtonsBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFormRadioButtonsItem: IFormRadioButtonsItem, themeColor: Int) {
        binding?.tvLabel?.text = iFormRadioButtonsItem.labelName
        binding?.llRadioButtons?.removeAllViews()
        iFormRadioButtonsItem.options.forEach { option ->
            val radioButton = RadioButton(context)
            radioButton.text = option.label
            radioButton.isChecked = option.isChecked
            radioButton.tag = option
            radioButton.buttonTintList = ColorStateList.valueOf(themeColor)
            radioButton.setOnClickListener { view ->
                val optionTag = view.tag as IFormItemCheckableOption
                if (!optionTag.isChecked) {
                    resetPreviouslyChecked()
                    val newCheckedState = !optionTag.isChecked
                    (view as RadioButton).isChecked = newCheckedState
                    optionTag.isChecked = newCheckedState
                }
            }
            binding?.llRadioButtons?.addView(radioButton)
        }
        setError(iFormRadioButtonsItem)
    }

    private fun resetPreviouslyChecked() {
        binding?.llRadioButtons?.children?.forEach { view ->
            val addedRadioButton = (view as RadioButton)

            val optionTag = view.tag as IFormItemCheckableOption
            if (optionTag.isChecked) {
                optionTag.isChecked = false
            }

            addedRadioButton.isChecked = false
        }
    }

    private fun setError(iFormItem: IFormItem) {
        binding?.tvError?.visibility =
            if (!iFormItem.errorMessage.isNullOrBlank()) VISIBLE else GONE
        binding?.tvError?.text = iFormItem.errorMessage
    }
}