package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewMediaOverlayRetryBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class MediaOverlayRetryView : FrameLayout {

    private var binding: ViewMediaOverlayRetryBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewMediaOverlayRetryBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(errorMessage: String?, retryTag: Any?, onClickListener: OnClickListener) {
        errorMessage?.let {
            binding?.tvFailureMessage?.text = it
            binding?.btRetry?.tag = retryTag
            binding?.btRetry?.setOnClickListener(onClickListener)
            visibility = VISIBLE
        } ?: kotlin.run {
            visibility = GONE
        }
    }
}