package ai.engagely.openbot.model.network

import okhttp3.OkHttpClient
import okhttp3.logging.HttpLoggingInterceptor
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit


class ApiClient(private val client: Retrofit) {

    fun getClient() = client

    companion object {

        @Volatile
        private var INSTANCE: ApiClient? = null

        fun getInstance(): ApiClient = INSTANCE ?: synchronized(this) {
            INSTANCE ?: createRetrofitClient().also { INSTANCE = it }
        }

        private fun createRetrofitClient(): ApiClient {
            val interceptor = HttpLoggingInterceptor()
            interceptor.level = HttpLoggingInterceptor.Level.BODY
            val client = OkHttpClient.Builder()
                .readTimeout(ApiConstants.API_REQUEST_TIMEOUT_SECONDS, TimeUnit.SECONDS)
                .connectTimeout(ApiConstants.API_REQUEST_TIMEOUT_SECONDS, TimeUnit.SECONDS)
                .addInterceptor(interceptor).build()

            val retrofit: Retrofit = Retrofit.Builder()
                .baseUrl(ApiConstants.BASE_URL)
                .client(client)
                .addConverterFactory(GsonConverterFactory.create())
                .build()
            return ApiClient(retrofit);
        }
    }
}