package ai.engagely.openbot.model.pojos.internal.chat

import ai.engagely.openbot.model.pojos.internal.botsettings.IGreetingCarousalImage
import java.util.*

class ICarousalImageItem(
    val header: String?,
    val messages: List<String>?,
    val images: List<IGreetingCarousalImage>,
    val textColor: String?,
    date: Date?,
    isLoading: Boolean,
    isBotItem: Boolean,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {
    override fun makeACopy(): IChatItem {
        return ICarousalImageItem(
            header = header,
            messages = messages,
            images = images,
            textColor = textColor,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}