package ai.engagely.openbot.model.repositories

import ai.engagely.openbot.model.pojos.internal.chat.IChatFormItem
import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoResponseParams
import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatBusinessAwayData


interface ChatRepository {

    suspend fun sendMessage(
        channelName: String,
        userInput: String,
        fieldText: String?,
        isFromProcessTree: Boolean?,
        queryType: String?,
        botId: String?,
        intId: String?,
        intName: String?,
        sessionId: String?,
        sessionObj: Any?,
        userId: String?,
        prevLangCode: String?,
        userLang: String?
    ): Boolean

    suspend fun sendFlow(
        dynamicSelectedField: String?,
        inputId: String?,
        intId: String?,
        journeyId: String?,
        languageCode: String?,
        messageType: String?,
        msgId: String?,
        nodeId: Int?,
        queryType: String?,
        selectedField: String?,
        sessionId: String?,
        sessionObj: Any?,
        userInput: String?
    ): Boolean

    suspend fun sendFaq(
        botId: String?,
        channel: String?,
        faqId: String?,
        inputDateNTime: String?,
        intId: String?,
        intName: String?,
        journeyID: String?,
        pageUrl: String?,
        prevLangCode: String?,
        question: String?,
        resBy: String?,
        resTime: String?,
        sessionId: String?,
        sessionObj: Any?,
        userId: String?,
        userLang: String?
    ): Boolean

    suspend fun sendTabularInfo(
        headings: List<String>?,
        inputId: String?,
        intId: String?,
        isMapEnabled: Boolean?,
        journeyId: String?,
        languageCode: String?,
        messageType: String?,
        msgId: String?,
        nextDimension: String?,
        responseId: String?,
        responseParams: ITabularInfoResponseParams?,
        selectedEnVal: Map<String, String>?,
        selectedTransVal: Map<String, String>?,
        sessionId: String?,
        sessionObj: Any?,
        userInput: String?,
        uniqueId: String?
    ): Boolean

    suspend fun saveBAFData(
        iChatFormItem: IChatFormItem,
        iLiveChatBusinessAwayData: ILiveChatBusinessAwayData,
        socketId: String?
    ): Boolean
}