package ai.engagely.openbot.model.repositories.impl

import ai.engagely.openbot.model.constants.ServerConstants
import ai.engagely.openbot.model.network.ApiClient
import ai.engagely.openbot.model.network.ApiConstants
import ai.engagely.openbot.model.network.interfaces.EngagementApi
import ai.engagely.openbot.model.pojos.external.apirequests.updateengagement.PostEngageRequest
import ai.engagely.openbot.model.pojos.external.apirequests.updateengagement.UpdateEngagementRequest
import ai.engagely.openbot.model.pojos.internal.engagement.IWelcomeDataItem
import ai.engagely.openbot.model.repositories.EngagementRepository
import ai.engagely.openbot.model.utils.general.LogUtils
import com.google.gson.internal.LinkedTreeMap
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.withContext
import java.net.HttpURLConnection

class AppEngagementRepository(
    private val dispatcher: CoroutineDispatcher,
) : EngagementRepository {

    override suspend fun updateEngagement(
        botId: String,
        userId: String?,
        sessionId: String?
    ): List<IWelcomeDataItem> {
        return withContext(dispatcher) {
            try {
                val updateEngagementRequest = UpdateEngagementRequest(
                    data = ArrayList(),
                    userId = userId,
                    sessionId = sessionId,
                    intId = botId
                )
                val response =
                    ApiClient.getInstance().getClient().create(EngagementApi::class.java)
                        .updateEngagement(request = updateEngagementRequest)
                if (response.isSuccessful && HttpURLConnection.HTTP_OK == response.code() && response.body() != null) {
                    val updateEngagementResponse = response.body()

                    val welcomeData: ArrayList<IWelcomeDataItem> = ArrayList()
                    updateEngagementResponse?.firstOrNull()?.engagementMsg
                        ?.forEach {
                            if (it?.respondType?.isNotBlank() == true && it.data != null) {
                                when (it.respondType) {
                                    ServerConstants.ENGAGEMENT_RESPONSE_TYPE_TEXT -> {
                                        if (it.data is String && it.data.isNotBlank()) {
                                            welcomeData.add(
                                                IWelcomeDataItem(
                                                    type = IWelcomeDataItem.IWelcomeDataType.TEXT,
                                                    data = it.data
                                                )
                                            )
                                        }
                                    }
                                    ServerConstants.ENGAGEMENT_RESPONSE_TYPE_IMAGE -> {
                                        if (it.data is String && it.data.isNotBlank()) {
                                            welcomeData.add(
                                                IWelcomeDataItem(
                                                    type = IWelcomeDataItem.IWelcomeDataType.IMAGE,
                                                    data = ApiConstants.WELCOME_ITEM_IMAGE_BASE_URL + it.data
                                                )
                                            )
                                        }

                                    }
                                    ServerConstants.ENGAGEMENT_RESPONSE_TYPE_VIDEO -> {
                                        if (it.data is LinkedTreeMap<*, *> && it.data.containsKey(
                                                ApiConstants.VIDEO_NAME_KEY
                                            )
                                            && it.data[ApiConstants.VIDEO_NAME_KEY] is String
                                        ) {
                                            val videoName =
                                                it.data[ApiConstants.VIDEO_NAME_KEY] as String
                                            if (videoName.isNotBlank()) {
                                                welcomeData.add(
                                                    IWelcomeDataItem(
                                                        type = IWelcomeDataItem.IWelcomeDataType.VIDEO,
                                                        data = ApiConstants.WELCOME_ITEM_VIDEO_BASE_URL + videoName
                                                    )
                                                )
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    return@withContext welcomeData
                }
            } catch (e: Exception) {
                LogUtils.logException(e)
            }
            return@withContext emptyList()
        }
    }

    override suspend fun sendPostEngage(
        intId: String?,
        ruleId: String?,
        sessionId: String?,
        socketId: String?,
        userId: String?
    ): Boolean {
        return withContext(dispatcher) {
            try {
                val postEngageRequest = PostEngageRequest(
                    intId = intId,
                    ruleId = ruleId,
                    sessionId = sessionId,
                    socketId = socketId,
                    userId = userId
                )
                val postEngageResponse =
                    ApiClient.getInstance().getClient().create(EngagementApi::class.java)
                        .triggerPostEngage(postEngageRequest)

                return@withContext (postEngageResponse.isSuccessful
                        && HttpURLConnection.HTTP_OK == postEngageResponse.code()
                        && postEngageResponse.body()?.success == true)
            } catch (e: Exception) {
                LogUtils.logException(e)
                return@withContext false
            }
        }
    }
}