package ai.engagely.openbot.model.utils.helpers

import android.view.MotionEvent
import android.view.View

class RequestParentTouchForScrollHelper : View.OnTouchListener {

    override fun onTouch(view: View?, motionEvent: MotionEvent?): Boolean {
        if (view == null || motionEvent == null) return false
        var scrolling = Scrolling.IDLE
        val historySize: Int = motionEvent.historySize
        val pointerCount: Int = motionEvent.pointerCount
        var historicalY = 0f
        var y = 0f
        for (h in 0 until historySize) {
            for (p in 0 until pointerCount) {
                motionEvent.getHistoricalY(p, h).let {
                    if (historicalY < it) {
                        historicalY = it
                    }
                }
            }
        }
        for (p in 0 until pointerCount) {
            motionEvent.getY(p).let {
                if (y < it) {
                    y = it
                }
            }
        }
        if (historicalY != 0f && y != 0f) {
            if (y < historicalY) {
                scrolling = Scrolling.UP
            } else if (y > historicalY) {
                scrolling = Scrolling.DOWN
            }
        }
        if (scrolling == Scrolling.UP && !view.canScrollVertically(1)) {
            view.parent.requestDisallowInterceptTouchEvent(false)
            return false
        } else if (scrolling == Scrolling.DOWN && !view.canScrollVertically(-1)) {
            view.parent.requestDisallowInterceptTouchEvent(false)
            return false
        }
        if (motionEvent.action == MotionEvent.ACTION_UP) {
            view.parent.requestDisallowInterceptTouchEvent(false)
        } else {
            view.parent.requestDisallowInterceptTouchEvent(true)
        }
        return false
    }

    enum class Scrolling { UP, DOWN, IDLE }
}