package ai.engagely.openbot.view.adapters.viewholders

import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoItem
import ai.engagely.openbot.view.customviews.TabularInfoWithMapView
import android.view.View
import androidx.recyclerview.widget.RecyclerView
import com.google.android.gms.maps.CameraUpdateFactory
import com.google.android.gms.maps.GoogleMap
import com.google.android.gms.maps.MapsInitializer
import com.google.android.gms.maps.OnMapReadyCallback
import com.google.android.gms.maps.model.LatLng
import com.google.android.gms.maps.model.MarkerOptions

class TabularInfoWithMapHolder(private val view: TabularInfoWithMapView) :
    RecyclerView.ViewHolder(view), OnMapReadyCallback {

    private lateinit var map: GoogleMap
    private lateinit var latLng: LatLng

    init {
        view.getMapView()?.run {
            // Initialise the MapView
            onCreate(null)
            // Set the map ready callback to receive the GoogleMap object
            getMapAsync(this@TabularInfoWithMapHolder)
        }
    }

    fun setData(
        tabularInfoItem: ITabularInfoItem?,
        textColor: Int,
        bgColor: Int,
        onClickListener: View.OnClickListener
    ) {
        view.setData(tabularInfoItem, textColor, bgColor, onClickListener)

        if (tabularInfoItem?.isMapEnabled == true && tabularInfoItem.latitude != null && tabularInfoItem.longitude != null) {
            latLng = LatLng(tabularInfoItem.latitude, tabularInfoItem.longitude)
            setMapLocation()
        }
    }

    override fun onMapReady(googleMap: GoogleMap) {
        MapsInitializer.initialize(view.context)
        // If map is not initialised properly
        map = googleMap ?: return
        setMapLocation()
    }

    private fun setMapLocation() {
        if (!::map.isInitialized) return
        if (!::latLng.isInitialized) return
        with(map) {
            moveCamera(CameraUpdateFactory.newLatLngZoom(latLng, 13f))
            addMarker(MarkerOptions().position(latLng))
            mapType = GoogleMap.MAP_TYPE_NORMAL
            setOnMapClickListener {

            }
        }
    }

    fun clearView() {
        if (!::map.isInitialized) return
        with(map) {
            // Clear the map and free up resources by changing the map type to none
            clear()
            mapType = GoogleMap.MAP_TYPE_NONE
        }
    }
}