package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewFormTextAreaBinding
import ai.engagely.openbot.model.pojos.internal.history.IFormItem
import ai.engagely.openbot.model.pojos.internal.history.IFormTextAreaItem
import ai.engagely.openbot.model.utils.validators.FormItemValidator
import android.content.Context
import android.text.Editable
import android.text.TextWatcher
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class FormTextAreaView : FrameLayout {

    private var binding: ViewFormTextAreaBinding? = null
    private var textWatcher: TextWatcher? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewFormTextAreaBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFormTextAreaItem: IFormTextAreaItem?) {
        binding?.let { rootView ->
            iFormTextAreaItem?.let { textAreaItem ->
                rootView.tvLabel.text = textAreaItem.labelName
                rootView.etText.hint = textAreaItem.placeHolder
                rootView.etText.setText(textAreaItem.value)
                rootView.etText.minLines = textAreaItem.rows
                setError(iFormTextAreaItem)
            }

            textWatcher?.let {
                rootView.etText.removeTextChangedListener(it)
            }
            textWatcher = object : TextWatcher {
                override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {}

                override fun onTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
                    iFormTextAreaItem?.apply {
                        value = p0?.toString() ?: ""
                        FormItemValidator.validateFormItem(this, context)
                        setError(this)
                    }
                }

                override fun afterTextChanged(p0: Editable?) {}

            }
            rootView.etText.addTextChangedListener(textWatcher)
        }
    }

    private fun setError(iFormItem: IFormItem) {
        binding?.tvError?.visibility =
            if (!iFormItem.errorMessage.isNullOrBlank()) VISIBLE else GONE
        binding?.tvError?.text = iFormItem.errorMessage
    }
}