package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewMultipleOptionItemBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class MultipleOptionsItemView : FrameLayout {

    private var binding: ViewMultipleOptionItemBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewMultipleOptionItemBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(name: String?, isNew: Boolean) {
        binding?.tvOptionName?.text = name;
        binding?.tvNew?.visibility = if (isNew) VISIBLE else GONE
    }
}