package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewPlaybackSpeedMenuBinding
import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.LayoutInflater
import android.widget.FrameLayout
import android.widget.PopupMenu

class PlaybackSpeedMenu : FrameLayout {

    private var binding: ViewPlaybackSpeedMenuBinding? = null
    private var speed: Float = 1f

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewPlaybackSpeedMenuBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(speed: Float, playbackSpeedListener: PlaybackSpeedListener) {
        this.speed = speed
        binding?.ibPlaybackSpeed?.setOnClickListener { clickedView ->
            val popupMenu = PopupMenu(context, clickedView, Gravity.END)
            popupMenu.menuInflater.inflate(R.menu.video_playback_speed_menu, popupMenu.menu)

            when (this.speed) {
                0.25f -> popupMenu.menu.findItem(R.id.speed_point_two_five)?.isChecked = true
                0.5f -> popupMenu.menu.findItem(R.id.speed_point_five)?.isChecked = true
                0.75f -> popupMenu.menu.findItem(R.id.speed_point_seven_five)?.isChecked = true
                1f -> popupMenu.menu.findItem(R.id.speed_normal)?.isChecked = true
                1.25f -> popupMenu.menu.findItem(R.id.speed_one_point_two_five)?.isChecked = true
                1.5f -> popupMenu.menu.findItem(R.id.speed_one_point_five)?.isChecked = true
                1.75f -> popupMenu.menu.findItem(R.id.speed_one_point_seven_five)?.isChecked = true
                2f -> popupMenu.menu.findItem(R.id.speed_two)?.isChecked = true
            }

            popupMenu.show()
            popupMenu.setOnMenuItemClickListener {
                when (it.itemId) {
                    R.id.speed_point_two_five -> playbackSpeedListener.onPlaybackSpeedChanged(0.25f)
                    R.id.speed_point_five -> playbackSpeedListener.onPlaybackSpeedChanged(0.5f)
                    R.id.speed_point_seven_five -> playbackSpeedListener.onPlaybackSpeedChanged(
                        0.75f
                    )
                    R.id.speed_normal -> playbackSpeedListener.onPlaybackSpeedChanged(1f)
                    R.id.speed_one_point_two_five -> playbackSpeedListener.onPlaybackSpeedChanged(
                        1.25f
                    )
                    R.id.speed_one_point_five -> playbackSpeedListener.onPlaybackSpeedChanged(1.5f)
                    R.id.speed_one_point_seven_five -> playbackSpeedListener.onPlaybackSpeedChanged(
                        1.75f
                    )
                    R.id.speed_two -> playbackSpeedListener.onPlaybackSpeedChanged(2f)
                }
                true
            }
        }
    }

    interface PlaybackSpeedListener {
        fun onPlaybackSpeedChanged(speed: Float)
    }
}