package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewExoplayerMoreMenuBinding
import android.content.Context
import android.os.Build
import android.util.AttributeSet
import android.view.Gravity
import android.view.LayoutInflater
import android.view.Menu
import android.widget.FrameLayout
import android.widget.PopupMenu

class PlayerMoreMenuView : FrameLayout {

    private var binding: ViewExoplayerMoreMenuBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewExoplayerMoreMenuBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(playerMoreMenuClickListener: PlayerMoreMenuClickListener) {
        binding?.ibMore?.setOnClickListener { clickedView ->
            val popupMenu = PopupMenu(context, clickedView, Gravity.END)
            popupMenu.menu.add(Menu.NONE, DOWNLOAD_ITEM_ID, 0, context.getString(R.string.download))

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
                popupMenu.menu.add(
                    Menu.NONE,
                    PICTURE_IN_PICTURE_ITEM_ID,
                    1,
                    context.getString(R.string.picture_in_picture)
                )
            }

            popupMenu.show()
            popupMenu.setOnMenuItemClickListener {
                if (it.itemId == DOWNLOAD_ITEM_ID) {
                    playerMoreMenuClickListener.onDownloadMenuSelected()
                } else if (it.itemId == PICTURE_IN_PICTURE_ITEM_ID) {
                    playerMoreMenuClickListener.onPictureInPictureSelected()
                }
                true
            }
        }
    }

    interface PlayerMoreMenuClickListener {
        fun onDownloadMenuSelected()
        fun onPictureInPictureSelected()
    }

    companion object {
        const val DOWNLOAD_ITEM_ID = 0
        const val PICTURE_IN_PICTURE_ITEM_ID = 1
    }
}