package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewWelcomeDataBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IPlayerSize
import ai.engagely.openbot.model.pojos.internal.engagement.IWelcomeDataItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import androidx.core.view.forEach
import com.google.android.exoplayer2.Player

class WelcomeDataView : FrameLayout {

    private var binding: ViewWelcomeDataBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewWelcomeDataBinding.inflate(LayoutInflater.from(context), this, true)
        binding?.ivClose?.setOnClickListener {
            visibility = GONE
        }
    }

    fun setData(
        welcomeDataItems: List<IWelcomeDataItem>,
        color: Int,
        onPlayClickListener: WelcomeVideoView.OnPlayClickListener?
    ) {
        visibility = VISIBLE
        binding?.llWelcomeDataContainer?.removeAllViews()
        welcomeDataItems.forEach {
            val welcomeItemView: View?
            when (it.type) {
                IWelcomeDataItem.IWelcomeDataType.IMAGE -> {
                    welcomeItemView = WelcomeImageView(context)
                    welcomeItemView.setData(it.data)
                    binding?.llWelcomeDataContainer?.addView(welcomeItemView)
                }
                IWelcomeDataItem.IWelcomeDataType.TEXT -> {
                    welcomeItemView = WelcomeMessageView(context)
                    welcomeItemView.setData(it.data, color)
                    binding?.llWelcomeDataContainer?.addView(welcomeItemView)
                }
                IWelcomeDataItem.IWelcomeDataType.VIDEO -> {
                    welcomeItemView = WelcomeVideoView(context)
                    welcomeItemView.setData(onPlayClickListener)
                    binding?.llWelcomeDataContainer?.addView(welcomeItemView)
                }
            }
        }
    }

    fun setPlayer(player: Player?) {
        binding?.llWelcomeDataContainer?.forEach {
            if (it is WelcomeVideoView) {
                it.setPlayer(player)
                return@forEach
            }
        }
    }

    fun setVolumeMuted(muted: Boolean?) {
        binding?.llWelcomeDataContainer?.forEach {
            if (it is WelcomeVideoView) {
                it.setVolumeMuted(muted)
                return@forEach
            }
        }
    }

    fun setPlaybackSpeed(speed: Float) {
        binding?.llWelcomeDataContainer?.forEach {
            if (it is WelcomeVideoView) {
                it.setPlaybackSpeed(speed)
                return@forEach
            }
        }
    }

    fun setPlayerPIPMode(isInPIPMode: Boolean?) {
        binding?.llWelcomeDataContainer?.forEach {
            if (it is WelcomeVideoView) {
                it.setPlayerPIPMode(isInPIPMode)
                return@forEach
            }
        }
    }

    fun getPlayerSize(): IPlayerSize? {
        binding?.llWelcomeDataContainer?.forEach {
            if (it is WelcomeVideoView) {
                return it.getPlayerSize()
            }
        }
        return null
    }
}