package ai.engagely.openbot.view.dialogfragments

import ai.engagely.openbot.databinding.FragmentBottomQuickMenuGridBinding
import ai.engagely.openbot.model.pojos.internal.botsettings.IQuickMenuItem
import ai.engagely.openbot.view.activities.BotChatActivity
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.google.android.material.bottomsheet.BottomSheetDialogFragment

class BottomQuickMenuGridDialogFragment : BottomSheetDialogFragment(), View.OnClickListener {

    private var binding: FragmentBottomQuickMenuGridBinding? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding = FragmentBottomQuickMenuGridBinding.inflate(inflater, container, false)
        return binding?.root
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val extraData = arguments?.getParcelableArrayList<IQuickMenuItem>(QUICK_MENU_LIST_EXTRA)
        if (extraData is List<IQuickMenuItem>) {
            binding?.vBottomQuickMenuGrid?.setData(extraData, this)
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        binding = null
    }

    companion object {
        private const val QUICK_MENU_LIST_EXTRA = "quick_menu_list_extra"

        fun getInstance(quickMenuList: List<IQuickMenuItem>): BottomQuickMenuGridDialogFragment {
            val fragment = BottomQuickMenuGridDialogFragment()

            val bundle = Bundle()
            bundle.putParcelableArrayList(QUICK_MENU_LIST_EXTRA, ArrayList(quickMenuList))
            fragment.arguments = bundle

            return fragment
        }
    }

    override fun onClick(view: View?) {
        if (activity is BotChatActivity) {
            (activity as BotChatActivity).onClick(view)
            dismiss()
        }
    }
}