package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IVideoItem(
    val title: String?,
    val description: String?,
    val videoText: String? = null,
    val fileSize: Int?,
    val url: String,
    val hideDetails: Boolean = false,
    val hideSideSpaces: Boolean = false,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    date = date,
    isBotItem = isBotItem,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IVideoItem(
            title = title,
            description = description,
            videoText = videoText,
            fileSize = fileSize,
            url = url,
            hideDetails = hideDetails,
            hideSideSpaces = hideSideSpaces,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}