package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewDialogueCarousalBinding
import ai.engagely.openbot.model.pojos.internal.chat.IDialogueCarousalItem
import ai.engagely.openbot.view.adapters.DialogueCarousalImageAdapter
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class DialogueCarousalView : FrameLayout {

    private var binding: ViewDialogueCarousalBinding? = null
    private val cardMargin by lazy {
        resources.getDimension(R.dimen.dialogue_carousal_card_margin)
    }
    private val cardHorizontalSpacing by lazy {
        resources.getDimension(R.dimen.dialogue_carousal_viewpager_horizontal_padding)
    }
    private val buttonHeight by lazy {
        resources.getDimension(R.dimen.dialogue_carousal_button_height)
    }
    private val titleHeight by lazy {
        resources.getDimension(R.dimen.dialogue_carousal_title_height)
    }
    private val horizontalDividerHeight by lazy {
        resources.getDimension(R.dimen.horizontal_divider_height)
    }

    private var imageHeight: Int = 0

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewDialogueCarousalBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun calculateDynamicSizes(screenWidth: Int) {
        imageHeight = (screenWidth - (2 * cardMargin) - (2 * cardHorizontalSpacing)).toInt()
    }

    fun setData(
        iDialogueCarousalItem: IDialogueCarousalItem?,
        itemClickListener: OnClickListener
    ) {
        iDialogueCarousalItem?.carousalDataContainer?.carousalData?.let { carousalData ->
            var maxButtonSize = 0
            carousalData.forEach { carousalItem ->
                carousalItem.buttonData?.size?.let { size ->
                    if (size > maxButtonSize) {
                        maxButtonSize = size
                    }
                }
            }
            val viewPagerHeight =
                (buttonHeight * maxButtonSize) + imageHeight + titleHeight + (2 * cardMargin) + (horizontalDividerHeight * maxButtonSize)
            binding?.rlImagePagerContainer?.apply {
                val viewPagerLayoutParams = layoutParams
                viewPagerLayoutParams.height = viewPagerHeight.toInt()
                layoutParams = viewPagerLayoutParams
            }
            binding?.vpImagePager?.apply {
                adapter = DialogueCarousalImageAdapter(
                    carousalData,
                    imageHeight.toInt(),
                    itemClickListener
                )
                binding?.tlImage?.setupWithViewPager(this, true)
            }

            binding?.ivNext?.setOnClickListener {
                val vpSize = carousalData.size
                var currentPosition = binding?.vpImagePager?.currentItem ?: 0
                if (currentPosition < (vpSize - 1)) {
                    binding?.vpImagePager?.setCurrentItem(++currentPosition, true)
                }
            }

            binding?.ivPrev?.setOnClickListener {
                var currentPosition = binding?.vpImagePager?.currentItem ?: 0
                if (currentPosition > 0) {
                    binding?.vpImagePager?.setCurrentItem(--currentPosition, true)
                }
            }
        }

        binding?.tvTime?.setData(iDialogueCarousalItem?.date)
    }
}