package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemLiveChatStatusBinding
import ai.engagely.openbot.model.pojos.internal.chat.ILiveChatStatusItem
import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatDataContainer
import ai.engagely.openbot.model.utils.exts.setCustomRoundedBg
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.text.parseAsHtml

class ItemLiveChatStatusView : FrameLayout {

    private var binding: ViewItemLiveChatStatusBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemLiveChatStatusBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iLiveChatStatusItem: ILiveChatStatusItem?,
        statusGreenColor: Int,
        statusBlueColor: Int,
        statusRedColor: Int
    ) {
        binding?.tvStatusMessage?.text =
            iLiveChatStatusItem?.statusMessage?.parseAsHtml()?.trimEnd()
        val cornerRadius = resources.getDimension(R.dimen.common_card_corner_radius)
        binding?.tvStatusMessage?.setCustomRoundedBg(
            when {
                ILiveChatDataContainer.ILiveChatStatus.CONNECTED == iLiveChatStatusItem?.status -> statusGreenColor
                ILiveChatDataContainer.ILiveChatStatus.QUEUED == iLiveChatStatusItem?.status -> statusRedColor
                ILiveChatDataContainer.ILiveChatStatus.BUSY == iLiveChatStatusItem?.status -> statusRedColor
                ILiveChatDataContainer.ILiveChatStatus.DISCONNECTED == iLiveChatStatusItem?.status -> statusBlueColor
                ILiveChatDataContainer.ILiveChatStatus.UNAVAILABLE == iLiveChatStatusItem?.status -> statusRedColor
                else -> statusBlueColor
            },
            cornerRadius
        )
    }
}