package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewUserImageWithTextBinding
import ai.engagely.openbot.model.pojos.internal.chat.IImageWithTextItem
import ai.engagely.openbot.model.pojos.internal.common.IViewImageData
import ai.engagely.openbot.model.utils.general.ImageUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemUserImageWithTextView : FrameLayout {

    private var binding: ViewUserImageWithTextBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewUserImageWithTextBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        data: IImageWithTextItem?,
        bgColor: Int,
        textColor: Int,
        onClickListener: OnClickListener
    ) {
        data?.imageUrl?.let { imageUrl ->
            binding?.ivMessageImage?.let { ivMessageImage ->
                ImageUtils.loadImage(context, imageUrl, ivMessageImage)
            }

            binding?.ivMessageImage?.tag = IViewImageData(imageUrl)
            binding?.ivMessageImage?.setOnClickListener(onClickListener)
        }

        binding?.tvMessage?.visibility = if (data?.imageText?.isNotBlank() == true) {
            VISIBLE
        } else GONE
        binding?.tvMessage?.text = data?.imageText

        binding?.tvMessage?.setTextColor(textColor)
        binding?.rlMessageContainer?.setCardBackgroundColor(bgColor)
        binding?.tvTime?.setData(data?.date, false)
    }
}