package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewItemYoutubeVideoBinding
import ai.engagely.openbot.model.pojos.internal.chat.IYouTubeVideoItem
import ai.engagely.openbot.model.utils.general.ImageUtils
import ai.engagely.openbot.model.utils.general.UrlUtils
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class ItemYouTubeVideoView : FrameLayout {

    private var binding: ViewItemYoutubeVideoBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewItemYoutubeVideoBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iYouTubeVideoItem: IYouTubeVideoItem?, onItemClickListener: OnClickListener) {
        binding?.tvTitle?.text = iYouTubeVideoItem?.title
        binding?.tvDescription?.text = iYouTubeVideoItem?.description
        binding?.btPlay?.tag = iYouTubeVideoItem
        binding?.btPlay?.setOnClickListener(onItemClickListener)

        binding?.ivBanner?.let { imageView ->
            iYouTubeVideoItem?.url?.let { url ->
                ImageUtils.loadImage(context, UrlUtils.getYouTubeBannerUrl(url), imageView)
            }
        }
    }
}