package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoItem
import android.content.Context
import android.util.AttributeSet
import android.widget.FrameLayout
import android.widget.LinearLayout
import com.google.android.material.card.MaterialCardView

abstract class TabularInfoBaseView : FrameLayout {

    constructor(context: Context) : super(context)

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs)

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    protected fun setData(
        tabularItemsContainer: LinearLayout?,
        timeText: ItemMessageTimeView?,
        bgCard: MaterialCardView?,
        actionButton: BotChatBubbleActionButtonView?,
        tabularInfoItem: ITabularInfoItem?,
        bgColor: Int,
        onClickListener: OnClickListener
    ) {
        tabularItemsContainer?.removeAllViews()

        tabularInfoItem?.childItems?.forEach {
            val verticalSpaceView = VerticalSpaceView(context)
            tabularItemsContainer?.addView(verticalSpaceView)

            val tabularSpinnerView = TabularSpinnerView(context)
            tabularSpinnerView.setData(tabularInfoItem, it, onClickListener)
            tabularItemsContainer?.addView(tabularSpinnerView)
        }

        val verticalSpaceView = VerticalSpaceView(context)
        tabularItemsContainer?.addView(verticalSpaceView)

        actionButton?.setData(
            tabularInfoItem?.responseParams?.submit,
            tabularInfoItem?.responseParams,
            onClickListener
        )

        bgCard?.setCardBackgroundColor(bgColor)
        timeText?.setData(tabularInfoItem?.date)
    }
}