package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewUserFeedbackBinding
import ai.engagely.openbot.model.pojos.internal.livechat.ILiveChatFeedbackRequest
import ai.engagely.openbot.model.utils.exts.setBorderBg
import ai.engagely.openbot.model.utils.exts.setCustomRoundedBg
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout

class UserFeedbackView : FrameLayout {

    private var binding: ViewUserFeedbackBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding = ViewUserFeedbackBinding.inflate(LayoutInflater.from(context), this, true)

        binding?.btCancel?.setOnClickListener {
            visibility = GONE
        }
    }

    fun setColor(color: Int) {
        val cornerRadius =
            resources.getDimension(R.dimen.common_button_corner_radius)
        val borderSize = resources.getDimension(R.dimen.common_button_border_size)
        binding?.btCancel.setBorderBg(color, borderSize.toInt(), cornerRadius)
        binding?.btCancel?.setTextColor(color)

        binding?.btSubmit.setCustomRoundedBg(color, cornerRadius)
    }

    fun setData(data: ILiveChatFeedbackRequest?, onClickListener: OnClickListener) {
        data?.let { liveChatFeedbackRequest ->
            liveChatFeedbackRequest.additionalQuestion?.let { additionalQuestion ->
                binding?.tvTitle?.text = additionalQuestion.additionalQuestion

                binding?.etAdditionalFeedback?.visibility = VISIBLE
                binding?.ratingBar?.visibility = GONE
                binding?.tvDescription?.visibility = GONE
                binding?.tvRatingMessage?.visibility = GONE
            } ?: kotlin.run {
                binding?.tvTitle?.text = liveChatFeedbackRequest.surveyMessage
                binding?.ratingBar?.rating = 0f
                binding?.ratingBar?.setOnRatingBarChangeListener { _, rating, _ ->
                    liveChatFeedbackRequest.ratings[rating.toInt()]?.let { selectedRating ->
                        selectedRating.rating?.let { ratingMessage ->
                            binding?.tvRatingMessage?.text = ratingMessage
                            binding?.tvRatingMessage?.visibility = VISIBLE
                            data.selectedIndex = rating.toInt()
                        }
                    }
                }
                binding?.etAdditionalFeedback?.setText("")

                binding?.ratingBar?.visibility = VISIBLE
                binding?.tvDescription?.visibility = VISIBLE
                binding?.etAdditionalFeedback?.visibility = GONE
            }

            binding?.btSubmit?.tag = data
            binding?.btSubmit?.setOnClickListener {
                data.additionalQuestion?.additionalAnswer =
                    binding?.etAdditionalFeedback?.text.toString()
                onClickListener.onClick(it)
            }

            if (liveChatFeedbackRequest.isLoading) {
                binding?.pbLoading?.visibility = VISIBLE
                binding?.btSubmit?.visibility = INVISIBLE
            } else {
                binding?.pbLoading?.visibility = GONE
                binding?.btSubmit?.visibility = VISIBLE
            }
            visibility = VISIBLE
        } ?: kotlin.run {
            visibility = GONE
        }
    }

}