package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.databinding.ViewWelcomeDataBinding
import ai.engagely.openbot.model.pojos.internal.engagement.IWelcomeDataItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout

class WelcomeDataView : FrameLayout {

    private var binding: ViewWelcomeDataBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewWelcomeDataBinding.inflate(LayoutInflater.from(context), this, true)
        binding?.ivClose?.setOnClickListener {
            visibility = GONE
        }
    }

    fun setData(
        welcomeDataItems: List<IWelcomeDataItem>,
        color: Int,
        onPlayClickListener: WelcomeVideoView.OnPlayClickListener?
    ) {
        visibility = VISIBLE
        binding?.llWelcomeDataContainer?.removeAllViews()
        welcomeDataItems.forEach {
            var welcomeItemView: View?
            when (it.type) {
                IWelcomeDataItem.IWelcomeDataType.IMAGE -> {
                    welcomeItemView = WelcomeImageView(context)
                    welcomeItemView.setData(it.data)
                    binding?.llWelcomeDataContainer?.addView(welcomeItemView)
                }
                IWelcomeDataItem.IWelcomeDataType.TEXT -> {
                    welcomeItemView = WelcomeMessageView(context)
                    welcomeItemView.setData(it.data, color)
                    binding?.llWelcomeDataContainer?.addView(welcomeItemView)
                }
                IWelcomeDataItem.IWelcomeDataType.VIDEO -> {
                    welcomeItemView = WelcomeVideoView(context)
                    welcomeItemView.setData(it.data, onPlayClickListener)
                    binding?.llWelcomeDataContainer?.addView(welcomeItemView)
                }
            }
        }
    }
}