package ai.engagely.openbot.model.pojos.internal.chat

import ai.engagely.openbot.model.pojos.internal.history.*
import ai.engagely.openbot.model.utils.general.DateUtils
import com.google.gson.internal.LinkedTreeMap
import java.util.*

class IChatFormItem(
    val formItemContainers: List<IFormItemsContainer>,
    val inputId: String?,
    val journeyId: String?,
    val languageCode: String?,
    val messageType: String?,
    val messageId: String?,
    val nodeId: Int?,
    val onSubmit: String?,
    val respondName: String?,
    val respondType: String?,
    val sessionId: String?,
    val userInput: String?,
    val submitType: SubmitType = SubmitType.API,
    val extras: Any? = null,
    date: Date?,
    isBotItem: Boolean,
    isHistoryItem: Boolean,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(
    isBotItem = isBotItem,
    date = date,
    isHistoryItem = isHistoryItem,
    uuid = uuid,
    pendingData = pendingData
) {
    override fun makeACopy(): IChatItem {
        return IChatFormItem(
            formItemContainers = formItemContainers,
            inputId = inputId,
            journeyId = journeyId,
            languageCode = languageCode,
            messageType = messageType,
            messageId = messageId,
            nodeId = nodeId,
            onSubmit = onSubmit,
            respondName = respondName,
            respondType = respondType,
            sessionId = sessionId,
            userInput = userInput,
            submitType = submitType,
            extras = extras,
            date = date,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }

    fun toFormData(): Any {
        val formData = LinkedTreeMap<String, Any>()
        formItemContainers.forEach { formItemContainer ->
            formItemContainer.formsItems.forEach { formItem ->
                when (formItem) {
                    is IFormTextItem -> {
                        formData[formItem.labelName] = formItem.value
                    }
                    is IFormTextAreaItem -> {
                        formData[formItem.labelName] = formItem.value
                    }
                    is IFormCheckboxesItem -> {
                        val checkedOptions = ArrayList<String>()
                        formItem.options.forEach { option ->
                            if (option.isChecked && !option.value.isNullOrBlank()) {
                                checkedOptions.add(option.value)
                            }
                        }
                        formData[formItem.labelName] = checkedOptions
                    }
                    is IFormRadioButtonsItem -> {
                        formItem.options.first { option ->
                            option.isChecked
                        }.value?.let { selectedRadioButtonValue ->
                            formData[formItem.labelName] = selectedRadioButtonValue
                        }
                    }
                    is IFormDateItem -> {
                        formItem.selectedDate?.let { selectedDate ->
                            formData[formItem.labelName] =
                                DateUtils.convertToServerDateFormat(selectedDate)
                        }
                    }
                    is IFormDropDownItem -> {
                        formItem.options[formItem.selectedOptionPosition].value?.let { value ->
                            formData[formItem.labelName] = value
                        }
                    }
                }
            }
        }
        return formData
    }

    enum class SubmitType { API, SOCKET }
}