package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class IImageWithTextItem(
    val imageUrl: String?,
    val imageText: String?,
    date: Date? = null,
    isLoading: Boolean = false,
    isBotItem: Boolean = false,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {
    override fun makeACopy(): IChatItem {
        return IImageWithTextItem(
            imageUrl = imageUrl,
            imageText = imageText,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}