package ai.engagely.openbot.model.pojos.internal.chat

import java.util.*

class ITabularInfoItem(
    val responseParams: ITabularInfoResponseParams?,
    val childItems: List<ITabularInfoChildItem>?,
    val inputId: String?,
    val isMapEnabled: Boolean,
    val journeyId: String?,
    val journeyName: String?,
    val languageCode: String?,
    val messageType: String?,
    val msgId: String?,
    val responseId: String?,
    val latitude: Double? = null,
    val longitude: Double? = null,
    date: Date?,
    isLoading: Boolean = false,
    isBotItem: Boolean = true,
    isHistoryItem: Boolean = false,
    uuid: String = UUID.randomUUID().toString(),
    pendingData: Any? = null
) : IChatItem(date, isLoading, isBotItem, isHistoryItem, uuid, pendingData) {

    fun isMapDataAvailable(): Boolean = isMapEnabled && latitude != null && longitude != null
    override fun makeACopy(): IChatItem {
        return ITabularInfoItem(
            responseParams = responseParams,
            childItems = childItems?.map { it.makeACopy() },
            inputId = inputId,
            isMapEnabled = isMapEnabled,
            journeyId = journeyId,
            journeyName = journeyName,
            languageCode = languageCode,
            messageType = messageType,
            msgId = msgId,
            responseId = responseId,
            latitude = latitude,
            longitude = longitude,
            date = date,
            isLoading = isLoading,
            isBotItem = isBotItem,
            isHistoryItem = isHistoryItem,
            uuid = uuid,
            pendingData = pendingData
        )
    }
}