package ai.engagely.openbot.model.utils.helpers

import ai.engagely.openbot.model.pojos.internal.chat.IChatItem
import ai.engagely.openbot.model.pojos.internal.chat.IMessageItem
import ai.engagely.openbot.model.pojos.internal.chat.IMessagesItem
import ai.engagely.openbot.model.pojos.internal.chat.ITabularInfoItem
import androidx.recyclerview.widget.DiffUtil

class ChatDiffUtilsHelper(
    private val oldItems: List<IChatItem>,
    private val newItems: List<IChatItem>
) : DiffUtil.Callback() {

    override fun getOldListSize(): Int {
        return oldItems.size
    }

    override fun getNewListSize(): Int {
        return newItems.size
    }

    override fun areItemsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
        return oldItems[oldItemPosition].uuid == newItems[newItemPosition].uuid
    }

    override fun areContentsTheSame(oldItemPosition: Int, newItemPosition: Int): Boolean {
        return compareItems(oldItemPosition, newItemPosition)
    }

    private fun compareItems(oldItemPosition: Int, newItemPosition: Int): Boolean {
        val oldItem = oldItems[oldItemPosition]
        val newItem = newItems[newItemPosition]
        val areSameItems = oldItem.uuid == newItem.uuid
        val areHavingSamePendingData = when {
            oldItem.pendingData != null -> {
                oldItem.pendingData == newItem.pendingData
            }
            newItem.pendingData != null -> {
                newItem.pendingData == oldItem.pendingData
            }
            else -> {
                true
            }
        }
        val areHavingSamePlayingState = if (oldItem is IMessageItem && newItem is IMessageItem) {
            oldItem.isVoicePlaying == newItem.isVoicePlaying
        } else if (oldItem is IMessagesItem && newItem is IMessagesItem) {
            oldItem.isVoicePlaying == newItem.isVoicePlaying
        } else {
            true
        }
        val areHavingSameTabularInfo = oldItem == newItem
            if (oldItem is ITabularInfoItem && newItem is ITabularInfoItem) {
                oldItem == newItem
            } else {
                true
            }
        return areSameItems && areHavingSamePlayingState && areHavingSamePendingData && areHavingSameTabularInfo
    }
}