package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewBotChatBubbleActionButtonBinding
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.content.ContextCompat

class BotChatBubbleActionButtonView : FrameLayout {

    private var binding: ViewBotChatBubbleActionButtonBinding? = null

    constructor(context: Context) : super(context) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi(context)
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi(context)
    }

    private fun initUi(context: Context) {
        binding =
            ViewBotChatBubbleActionButtonBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(buttonName: String?, tag: Any?, onClickListener: OnClickListener) {
        binding?.button?.setBackgroundColor(ContextCompat.getColor(context, R.color.button_blue))
        binding?.button?.text = buttonName
        binding?.button?.tag = tag
        binding?.button?.setOnClickListener(onClickListener)
    }
}