package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewFormSpinnerBinding
import ai.engagely.openbot.model.pojos.internal.history.IFormDropDownItem
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import android.widget.FrameLayout

class FormSpinnerView : FrameLayout {

    private var binding: ViewFormSpinnerBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewFormSpinnerBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(iFormDropDownItem: IFormDropDownItem?) {
        binding?.tvLabel?.text = iFormDropDownItem?.labelName

        iFormDropDownItem?.options?.let {
            val adapter = ArrayAdapter(context, R.layout.view_spinner_selected_item, it)
            adapter.setDropDownViewResource(R.layout.view_spinner_dopdown_item)
            binding?.spinner?.adapter = adapter
            binding?.spinner?.setSelection(iFormDropDownItem.selectedOptionPosition)
            binding?.spinner?.onItemSelectedListener = object : AdapterView.OnItemSelectedListener {
                override fun onItemSelected(
                    adapter: AdapterView<*>?,
                    parent: View?,
                    position: Int,
                    id: Long
                ) {
                    iFormDropDownItem.selectedOptionPosition = position
                }

                override fun onNothingSelected(adapter: AdapterView<*>?) {
                    //Nothing to do
                }
            }
        }
    }
}