package ai.engagely.openbot.view.customviews

import ai.engagely.openbot.R
import ai.engagely.openbot.databinding.ViewItemMessagesBinding
import ai.engagely.openbot.model.pojos.internal.chat.IMessagesItem
import ai.engagely.openbot.model.pojos.internal.history.IFormTextItem
import ai.engagely.openbot.view.adapters.ChatItemsRecyclerViewAdapter
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.core.content.ContextCompat

class ItemMessagesView : FrameLayout {

    private var binding: ViewItemMessagesBinding? = null

    constructor(context: Context) : super(context) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        initUi()
    }

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        initUi()
    }

    private fun initUi() {
        binding = ViewItemMessagesBinding.inflate(LayoutInflater.from(context), this, true)
    }

    fun setData(
        iMessagesItem: IMessagesItem?,
        bgColor: Int,
        textColor: Int,
        speechListener: ChatItemsRecyclerViewAdapter.SpeechListener?,
        viewClickListener: OnClickListener
    ) {
        binding?.cvMessagesContainer?.setCardBackgroundColor(bgColor)
        binding?.llMessagesContainer?.removeAllViews()

        iMessagesItem?.messages?.forEachIndexed { index, item ->
            if (index > 0) {
                val verticalSpace = VerticalSpaceView(context)
                binding?.llMessagesContainer?.addView(verticalSpace)
            }
            if (item is String) {
                val itemView = ItemMessagesItemView(context)
                itemView.setData(message = item, textColor = textColor, iMessagesItem.isHtml)
                binding?.llMessagesContainer?.addView(itemView)
            } else if (item is IFormTextItem) {
                val itemView = FormTextFieldView(context)
                itemView.setData(item, true)
                binding?.llMessagesContainer?.addView(itemView)
            }
        }

        if (IMessagesItem.IMessagesStyle.FORM == iMessagesItem?.messagesStyle) {
            binding?.llMessagesContainer?.addView(BotChatBubbleActionButtonView(context).apply {
                setData(resources.getString(R.string.submit), iMessagesItem, viewClickListener)
            })
        }

        binding?.tvTime?.setData(iMessagesItem?.date, iMessagesItem?.hideTime)

        if (speechListener != null && IMessagesItem.IMessagesStyle.MESSAGES == iMessagesItem?.messagesStyle) {
            binding?.ibSpeaker?.visibility = VISIBLE
            binding?.ibSpeaker?.setColorFilter(
                if (iMessagesItem.isVoicePlaying) ContextCompat.getColor(
                    context,
                    R.color.green
                ) else textColor
            )
            binding?.ibSpeaker?.setOnClickListener {
                iMessagesItem.messages.let {
                    speechListener.onSpeechRequested(iMessagesItem)
                }
            }
        } else {
            binding?.ibSpeaker?.visibility = GONE
        }
    }
}